﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Config
{
    public partial class UCTabAdvancedTest : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        public UCTabAdvancedTest()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;            
        }

        protected UCOptionsDetails UCDetails
        {
            get { return (UCOptionsDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            _gftpControlImageStart.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlImageStart.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlImageStart.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(StartImageChanged);
            _gPictureBoxStart.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
            _gButtonEditDALStart.Initialize(UCDetails.BLZSBELearning.RBL.ELearning.Course, AddCourse, false);

            _gftpControlImageEnd.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlImageEnd.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlImageEnd.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(EndImageChanged);
            _gPictureBoxEnd.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
            _gButtonEditDALEnd.Initialize(UCDetails.BLZSBELearning.RBL.ELearning.Course, AddCourse, false);
        }


        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            Gemini.Core.WinForms.Controls.GPictureBox _gPictureBox = sender as Gemini.Core.WinForms.Controls.GPictureBox;

            if (_gPictureBox != null)
            {
                _gPictureBox.Visible = true;
            }

        }

        void StartImageChanged()
        {
            if (_gftpControlImageStart.IsFileExist)
            {
                _gPictureBoxStart.Visible = false;
                _gPictureBoxStart.LoadAsync(_gftpControlImageStart.URL);
            }
            else
            {
                _gPictureBoxStart.Visible = false;
            }
        }

        void EndImageChanged()
        {
            if (_gftpControlImageEnd.IsFileExist)
            {
                _gPictureBoxEnd.Visible = false;
                _gPictureBoxEnd.LoadAsync(_gftpControlImageEnd.URL);
            }
            else
            {
                _gPictureBoxEnd.Visible = false;
            }
        }

        public override bool DoSave()
        {
            bool _return = true;

            #region Start
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.StartAdvancedTest.Abbreviaton, BL.Dictionary.Clients.PlugIn, _gTextBoxAbbreviationStart.Text);
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.StartAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn, _gButtonEditDALStart.ID);

            if (_gftpControlImageStart.IsFileExist)
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.StartAdvancedTest.ImageID, BL.Dictionary.Clients.PlugIn, _gftpControlImageStart.ID);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.StartAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn, _gftpControlImageStart.URL);
            }
            else
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.StartAdvancedTest.ImageID, BL.Dictionary.Clients.PlugIn, (long?)null);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.StartAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn, String.Empty);
            }
            #endregion

            #region End
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.EndAdvancedTest.Abbreviaton, BL.Dictionary.Clients.PlugIn, _gTextBoxAbbreviationEnd.Text);
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.EndAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn, _gButtonEditDALEnd.ID);

            if (_gftpControlImageStart.IsFileExist)
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.EndAdvancedTest.ImageID, BL.Dictionary.Clients.PlugIn, _gftpControlImageEnd.ID);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.EndAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn, _gftpControlImageEnd.URL);
            }
            else
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.EndAdvancedTest.ImageID, BL.Dictionary.Clients.PlugIn, (long?)null);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Tests.EndAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn, String.Empty);
            }
            #endregion

            return _return;
        }

        public override void DoRestore()
        {
            #region Start
            _gTextBoxAbbreviationStart.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Tests.StartAdvancedTest.Abbreviaton, BL.Dictionary.Clients.PlugIn);
            _gButtonEditDALStart.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.StartAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);
            _gftpControlImageStart.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.StartAdvancedTest.ImageID, BL.Dictionary.Clients.PlugIn);

            if (_gftpControlImageStart.ID.HasValue)
            {
                string _imageURLStart = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Tests.StartAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn);

                if (!String.IsNullOrEmpty(_imageURLStart))
                {
                    _gPictureBoxStart.Visible = false;
                    _gPictureBoxStart.LoadAsync(_imageURLStart);
                }
            }
            #endregion

            #region End
            _gTextBoxAbbreviationEnd.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Tests.EndAdvancedTest.Abbreviaton, BL.Dictionary.Clients.PlugIn);
            _gButtonEditDALEnd.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.EndAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);
            _gftpControlImageEnd.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.EndAdvancedTest.ImageID, BL.Dictionary.Clients.PlugIn);

            if (_gftpControlImageEnd.ID.HasValue)
            {
                string _imageURLEnd = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Tests.EndAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn);

                if (!String.IsNullOrEmpty(_imageURLEnd))
                {
                    _gPictureBoxStart.Visible = false;
                    _gPictureBoxStart.LoadAsync(_imageURLEnd);
                }
            }
            #endregion
        }

        private Gemini.Core.BL.Interface.BO.IBaseUnique<long?> AddCourse()
        {
            PI.FM.N000.Base.WinForms.Classes.Param _param = new PI.FM.N000.Base.WinForms.Classes.Param(Gemini.Core.WinForms.Interface.ShowMode.ModalWindow);
            PI.GM.N610.ELearning.BL.BO.Course.Search _search = new PI.GM.N610.ELearning.BL.BO.Course.Search();
            _search.TypeID = UCDetails.BLZSBELearning.BLELearning.Categorizatoin.RestoreByEnum((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.AdvancedTest).ID;
            Environment.WindowsHandler.Show(PI.GM.N610.ELearning.BL.Dictionary.WinFormsName, new Gemini.Core.WinForms.Base.AccessDescription(PI.GM.N610.ELearning.BL.Dictionary.Objects.UI.CourseList), _param, _search);

            return _param.Object;
        }
    }
}
